/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_PROCESS_API_
#define SPICE3_PROCESS_API_

#include "rlTypes.h"

RL_C_API rlResult rlProcessInitVariables(rlProcessVariables* variables);
RL_C_API rlResult rlProcessToStringVariables(const rlProcessVariables* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlProcessLoadVariables(rlHandle handle);
RL_C_API rlResult rlProcessStoreVariables(rlHandle handle);
RL_C_API rlResult rlProcessGetVariables(rlHandle handle, rlProcessVariables* variables);
RL_C_API rlResult rlProcessSetVariables(rlHandle handle, const rlProcessVariables* variables);

RL_C_API rlResult rlProcessGetSpeedScale(rlHandle handle, double* out);
RL_C_API rlResult rlProcessSetSpeedScale(rlHandle handle, double scale);

RL_C_API rlResult rlProcessGetTransformation(rlHandle handle, rlTransform3D* out);
RL_C_API rlResult rlProcessSetTransformation(rlHandle handle, rlTransform3D transform);

RL_C_API rlResult rlProcessWobbleSetCircle(rlHandle handle, rlProcessVariables* variables, double amplitude, double frequency);
RL_C_API rlResult rlProcessWobbleSetEight(rlHandle handle, rlProcessVariables* variables, const rlPoint2D* amplitude, double frequency);

#endif // SPICE3_PROCESS_API_
